// .mq4
// 
//      
#property copyright "mandorr@gmail.com"
#include <WinUser32.mqh>

void start() {
   string urrency=AccountCurrency();
   double deposit;
   double withdrawal;
   for (int i=0; i<HistoryTotal(); i++) {
      if (!OrderSelect(i,SELECT_BY_POS,MODE_HISTORY)) break;
      double openprice=OrderOpenPrice();
      double closeprice=OrderClosePrice();
      double profit=OrderProfit();
      if (openprice>0) continue;
      if (closeprice>0) continue;
      if (profit>0) deposit+=profit;
      if (profit<0) withdrawal+=withdrawal;
   }
   string symbol=Symbol();
   string market=MarketType(symbol);
   string base=symbol; if (market=="Forex") base=StringSubstr(symbol,0,3);
   double freemargin=AccountFreeMargin();
   double lotsize_base=MarketInfo(symbol,MODE_LOTSIZE);
   double lotmargin_base=0;
   double lotmargin_urrency_buy =0;
   double lotmargin_urrency_sell=0;
   double ask=MarketInfo(symbol,MODE_ASK);
   double bid=MarketInfo(symbol,MODE_BID);
   if (market=="Forex") {
      if (base==urrency) {ask=1; bid=1;}
      else {
         ask=MarketInfo(base+urrency,MODE_ASK);
         bid=MarketInfo(base+urrency,MODE_BID);
      }
   }
   double leverage=0;
   if (market=="Forex"  ) leverage=AccountLeverage();
   if (market=="Metalls") leverage=10;
   if (market=="CFD"    ) leverage=10;
   if (leverage>0) lotmargin_base=lotsize_base/leverage;
   lotmargin_urrency_buy =lotmargin_base*ask;
   lotmargin_urrency_sell=lotmargin_base*bid;
   if (market=="Futures") {
      lotmargin_base=FuturesLotMargin(symbol);
      lotmargin_urrency_buy =lotmargin_base;
      lotmargin_urrency_sell=lotmargin_base;
   }
   string lotmargin_buy =DoubleToStr(lotmargin_urrency_buy ,2)+" "+urrency;
   string lotmargin_sell=DoubleToStr(lotmargin_urrency_sell,2)+" "+urrency;
   if (market=="Forex" && base!=urrency) {
      lotmargin_buy =lotmargin_buy +" ("+DoubleToStr(lotmargin_base,2)+" "+base+")";
      lotmargin_sell=lotmargin_sell+" ("+DoubleToStr(lotmargin_base,2)+" "+base+")";
   }
   double freelots_buy =0;
   double freelots_sell=0;
   if (lotmargin_urrency_buy >0 && freemargin>0) freelots_buy =freemargin/lotmargin_urrency_buy ;
   if (lotmargin_urrency_sell>0 && freemargin>0) freelots_sell=freemargin/lotmargin_urrency_sell;
   double minlot=MarketInfo(symbol,MODE_MINLOT);
   int count_buy =0; if (minlot>0) count_buy =freelots_buy /minlot;
   int count_sell=0; if (minlot>0) count_sell=freelots_sell/minlot;
   freelots_buy =minlot*count_buy ;
   freelots_sell=minlot*count_sell;
   double tickvalue=MarketInfo(symbol,MODE_TICKVALUE);
   double swap_buy =0; if (minlot>0) swap_buy =MarketInfo(symbol,MODE_SWAPLONG )/minlot;
   double swap_sell=0; if (minlot>0) swap_sell=MarketInfo(symbol,MODE_SWAPSHORT)/minlot;
   double swap_buy_ticks =0; if (tickvalue>0) swap_buy_ticks =swap_buy /tickvalue;
   double swap_sell_ticks=0; if (tickvalue>0) swap_sell_ticks=swap_sell/tickvalue;
   string type=""; if(IsDemo()) type="";
   string field="          ";
   string msg=""
        +": "+AccountCompany()+field
   +"\n"+"  : "+AccountName()+field
   +"\n"+" : "+type+field
   +"\n"+" : "+AccountNumber()+field
   +"\n"+" : "+urrency+field
   +"\n"+": "+AccountLeverage()+field
   +"\n"+" : "+DoubleToStr(deposit,2)+" "+urrency+field
   +"\n"+"  : "+DoubleToStr(withdrawal,2)+" "+urrency+field
   +"\n"+": "+DoubleToStr(AccountBalance(),2)+" "+urrency+field
   +"\n"+": "+DoubleToStr(AccountEquity(),2)+" "+urrency+field
   +"\n"
   +"\n"+": "+symbol+field
   +"\n"+": "+market+field
   +"\n"+"   BUY : "+DoubleToStr(freelots_buy,1)+field
   +"\n"+"   SELL: "+DoubleToStr(freelots_sell,1)+field
   +"\n"+"    BUY : "+lotmargin_buy+field
   +"\n"+"    SELL: "+lotmargin_sell+field
   +"\n"+"    BUY : "+DoubleToStr(swap_buy,2)+" "+urrency+" ("+DoubleToStr(swap_buy_ticks,2)+" pips)"+field
   +"\n"+"    SELL: "+DoubleToStr(swap_sell,2)+" "+urrency+" ("+DoubleToStr(swap_sell_ticks,2)+" pips)"+field
   +"\n"+"   : "+DoubleToStr(tickvalue,2)+" "+urrency+" (1 pips)"+field
   +"\n"+" : "+DoubleToStr(minlot,1)+field
   +"\n"+"  : "+DoubleToStr(MarketInfo(symbol,MODE_LOTSTEP),1)+field
   +"\n"+": "+DoubleToStr(MarketInfo(symbol,MODE_POINT),MarketInfo(symbol,MODE_DIGITS))+field
   +"\n"+": "+DoubleToStr(MarketInfo(symbol,MODE_DIGITS),0)+field
   +"\n"+": "+DoubleToStr(MarketInfo(symbol,MODE_SPREAD),0)+field
   +"\n"+" : "+DoubleToStr(MarketInfo(symbol,MODE_STOPLEVEL),0)+field
   ;
   string title="     ";
   MessageBox(msg,title,MB_OK|MB_ICONINFORMATION);
}

string MarketType (string symbol) {
   int len=StringLen(symbol);
   string base;
   if (StringSubstr(symbol,0,1)=="_") return ("Indexes");
   if (StringSubstr(symbol,0,1)=="#") {
      base=StringSubstr(symbol,len-1,1);
      if (base=="0") return ("Futures");
      if (base=="1") return ("Futures");
      if (base=="2") return ("Futures");
      if (base=="3") return ("Futures");
      if (base=="4") return ("Futures");
      if (base=="5") return ("Futures");
      if (base=="6") return ("Futures");
      if (base=="7") return ("Futures");
      if (base=="8") return ("Futures");
      if (base=="9") return ("Futures");
      return ("CFD");
   }
   else {
      if (symbol=="GOLD"  ) return ("Metalls");
      if (symbol=="SILVER") return ("Metalls");
      base=StringSubstr(symbol,0,3);
      if (base=="AUD") return ("Forex");
      if (base=="CAD") return ("Forex");
      if (base=="CHF") return ("Forex");
      if (base=="EUR") return ("Forex");
      if (base=="GBP") return ("Forex");
      if (base=="LFX") return ("Forex");
      if (base=="NZD") return ("Forex");
      if (base=="SGD") return ("Forex");
      if (base=="USD") return ("Forex");
   }
   return ("");
}

double FuturesLotMargin (string symbol) {
   double result=0;
   string urrency=AccountCurrency();
   double bid=1; if (urrency!="USD") bid=MarketInfo(urrency+"USD",MODE_BID);
   int len=StringLen(symbol);
   string base=StringSubstr(symbol,0,len-2);
   if (base=="#ENQ" ) result=bid*3750;
   if (base=="#EP"  ) result=bid*3938;
   if (base=="#SLV" ) result=bid*5063;
   if (base=="#GOLD") result=bid*2363;
   if (base=="#CL"  ) result=bid*4725;
   if (base=="#NG"  ) result=bid*8100;
   if (base=="#W"   ) result=bid* 608;
   if (base=="#S"   ) result=bid*1148;
   if (base=="#C"   ) result=bid* 473;
   return (result);
}
// End